#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

struct Point {
    int x, y;
    Point(int x=0, int y=0): x(x), y(y) {}
};

int cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

double polygonArea(const vector<Point>& hull) {
    int n = hull.size();
    double area = 0;
    for (int i = 0; i < n; ++i) {
        int j = (i + 1) % n;
        area += hull[i].x * hull[j].y - hull[i].y * hull[j].x;
    }
    return abs(area) / 2.0;
}

vector<Point> convexHull(vector<Point>& points) {
    sort(points.begin(), points.end(), [](const Point& a, const Point& b) {
        return a.x < b.x || (a.x == b.x && a.y < b.y);
    });
    int n = points.size();
    vector<Point> hull;

    for (int i = 0; i < n; ++i) {
        while (hull.size() >= 2 && cross(hull[hull.size()-2], hull[hull.size()-1], points[i]) <= 0)
            hull.pop_back();
        hull.push_back(points[i]);
    }

    int t = hull.size() + 1;
    for (int i = n - 1; i >= 0; --i) {
        while (hull.size() >= t && cross(hull[hull.size()-2], hull[hull.size()-1], points[i]) <= 0)
            hull.pop_back();
        hull.push_back(points[i]);
    }

    hull.pop_back(); 
    return hull;
}

int main() {
    int N;
    cin >> N;

    vector<Point> points(N);
    for (int i = 0; i < N; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    double minArea = 1e9;

    for (int i = 0; i < N; ++i) {
        vector<Point> remainingPoints;
        for (int j = 0; j < N; ++j) {
            if (i != j) {
                remainingPoints.push_back(points[j]);
            }
        }
        vector<Point> hull = convexHull(remainingPoints);
        minArea = min(minArea, polygonArea(hull));
    }

    cout << (int)round(minArea) << endl;
    return 0;
}